/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
// m_flash.c

#include "shared/shared.h"
#include "shared/m_flash.h"

// this file is included in both the game dll and quake2,
// the game needs it to source shot locations, the client
// needs it to position muzzle flashes
const vec3_t monster_flash_offset[MZ2_LAST] = {
    [MZ2_TANK_BLASTER_1] = { 28.7f, -18.5f, 28.7f },
    [MZ2_TANK_BLASTER_2] = { 24.6f, -21.5f, 30.1f },
    [MZ2_TANK_BLASTER_3] = { 19.8f, -23.9f, 32.1f },
    [MZ2_TANK_MACHINEGUN_1] = { 22.9f, -0.7f, 25.3f },
    [MZ2_TANK_MACHINEGUN_2] = { 22.2f, 6.2f, 22.3f },
    [MZ2_TANK_MACHINEGUN_3] = { 19.4f, 13.1f, 18.6f },
    [MZ2_TANK_MACHINEGUN_4] = { 19.4f, 18.8f, 18.6f },
    [MZ2_TANK_MACHINEGUN_5] = { 17.9f, 25.0f, 18.6f },
    [MZ2_TANK_MACHINEGUN_6] = { 14.1f, 30.5f, 20.6f },
    [MZ2_TANK_MACHINEGUN_7] = { 9.3f, 35.3f, 22.1f },
    [MZ2_TANK_MACHINEGUN_8] = { 4.7f, 38.4f, 22.1f },
    [MZ2_TANK_MACHINEGUN_9] = { -1.1f, 40.4f, 24.1f },
    [MZ2_TANK_MACHINEGUN_10] = { -6.5f, 41.2f, 24.1f },
    [MZ2_TANK_MACHINEGUN_11] = { 3.2f, 40.1f, 24.7f },
    [MZ2_TANK_MACHINEGUN_12] = { 11.7f, 36.7f, 26.0f },
    [MZ2_TANK_MACHINEGUN_13] = { 18.9f, 31.3f, 26.0f },
    [MZ2_TANK_MACHINEGUN_14] = { 24.4f, 24.4f, 26.4f },
    [MZ2_TANK_MACHINEGUN_15] = { 27.1f, 17.1f, 27.2f },
    [MZ2_TANK_MACHINEGUN_16] = { 28.5f, 9.1f, 28.0f },
    [MZ2_TANK_MACHINEGUN_17] = { 27.1f, 2.2f, 28.0f },
    [MZ2_TANK_MACHINEGUN_18] = { 24.9f, -2.8f, 28.0f },
    [MZ2_TANK_MACHINEGUN_19] = { 21.6f, -7.0f, 26.4f },
    [MZ2_TANK_ROCKET_1] = { 6.2f, 29.1f, 49.1f },
    [MZ2_TANK_ROCKET_2] = { 6.9f, 23.8f, 49.1f },
    [MZ2_TANK_ROCKET_3] = { 8.3f, 17.8f, 49.5f },

    [MZ2_INFANTRY_MACHINEGUN_1] = { 26.6f, 7.1f, 13.1f },
    [MZ2_INFANTRY_MACHINEGUN_2] = { 18.2f, 7.5f, 15.4f },
    [MZ2_INFANTRY_MACHINEGUN_3] = { 17.2f, 10.3f, 17.9f },
    [MZ2_INFANTRY_MACHINEGUN_4] = { 17.0f, 12.8f, 20.1f },
    [MZ2_INFANTRY_MACHINEGUN_5] = { 15.1f, 14.1f, 21.8f },
    [MZ2_INFANTRY_MACHINEGUN_6] = { 11.8f, 17.2f, 23.1f },
    [MZ2_INFANTRY_MACHINEGUN_7] = { 11.4f, 20.2f, 21.0f },
    [MZ2_INFANTRY_MACHINEGUN_8] = { 9.0f, 23.0f, 18.9f },
    [MZ2_INFANTRY_MACHINEGUN_9] = { 13.9f, 18.6f, 17.7f },
    [MZ2_INFANTRY_MACHINEGUN_10] = { 15.4f, 15.6f, 15.8f },
    [MZ2_INFANTRY_MACHINEGUN_11] = { 10.2f, 15.2f, 25.1f },
    [MZ2_INFANTRY_MACHINEGUN_12] = { -1.9f, 15.1f, 28.2f },
    [MZ2_INFANTRY_MACHINEGUN_13] = { -12.4f, 13.0f, 20.2f },

    [MZ2_SOLDIER_BLASTER_1] = { 10.6f * 1.2f, 7.7f * 1.2f, 7.8f * 1.2f },
    [MZ2_SOLDIER_BLASTER_2] = { 25.1f * 1.2f, 3.6f * 1.2f, 19.0f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_1] = { 10.6f * 1.2f, 7.7f * 1.2f, 7.8f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_2] = { 25.1f * 1.2f, 3.6f * 1.2f, 19.0f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_1] = { 10.6f * 1.2f, 7.7f * 1.2f, 7.8f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_2] = { 25.1f * 1.2f, 3.6f * 1.2f, 19.0f * 1.2f },

    [MZ2_GUNNER_MACHINEGUN_1] = { 30.1f * 1.15f, 3.9f * 1.15f, 19.6f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_2] = { 29.1f * 1.15f, 2.5f * 1.15f, 20.7f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_3] = { 28.2f * 1.15f, 2.5f * 1.15f, 22.2f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_4] = { 28.2f * 1.15f, 3.6f * 1.15f, 22.0f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_5] = { 26.9f * 1.15f, 2.0f * 1.15f, 23.4f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_6] = { 26.5f * 1.15f, 0.6f * 1.15f, 20.8f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_7] = { 26.9f * 1.15f, 0.5f * 1.15f, 21.5f * 1.15f },
    [MZ2_GUNNER_MACHINEGUN_8] = { 29.0f * 1.15f, 2.4f * 1.15f, 19.5f * 1.15f },
    [MZ2_GUNNER_GRENADE_1] = { 4.6f * 1.15f, -16.8f * 1.15f, 7.3f * 1.15f },
    [MZ2_GUNNER_GRENADE_2] = { 4.6f * 1.15f, -16.8f * 1.15f, 7.3f * 1.15f },
    [MZ2_GUNNER_GRENADE_3] = { 4.6f * 1.15f, -16.8f * 1.15f, 7.3f * 1.15f },
    [MZ2_GUNNER_GRENADE_4] = { 4.6f * 1.15f, -16.8f * 1.15f, 7.3f * 1.15f },

    [MZ2_CHICK_ROCKET_1] = { 24.8f, -9.0f, 39.0f },

    [MZ2_FLYER_BLASTER_1] = { 14.1f, 13.4f, -7.0f },
    [MZ2_FLYER_BLASTER_2] = { 14.1f, -13.4f, -7.0f },

    [MZ2_MEDIC_BLASTER_1] = { 44.0f, 3.0f, 14.4f },

    [MZ2_GLADIATOR_RAILGUN_1] = { 30, 18, 28 },

    [MZ2_HOVER_BLASTER_1] = { 1.7f, 7.0f, 11.3f },

    [MZ2_ACTOR_MACHINEGUN_1] = { 18.4f, 7.4f, 9.6f },

    [MZ2_SUPERTANK_MACHINEGUN_1] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_MACHINEGUN_2] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_MACHINEGUN_3] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_MACHINEGUN_4] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_MACHINEGUN_5] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_MACHINEGUN_6] = { 30.0f, 39.0f, 85.5f },
    [MZ2_SUPERTANK_ROCKET_1] = { 16.0f, -22.5f, 108.7f },
    [MZ2_SUPERTANK_ROCKET_2] = { 16.0f, -33.4f, 106.7f },
    [MZ2_SUPERTANK_ROCKET_3] = { 16.0f, -42.8f, 104.7f },

    [MZ2_BOSS2_MACHINEGUN_L1] = { 32, -40, 70 },
    [MZ2_BOSS2_MACHINEGUN_L2] = { 32, -40, 70 },
    [MZ2_BOSS2_MACHINEGUN_L3] = { 32, -40, 70 },
    [MZ2_BOSS2_MACHINEGUN_L4] = { 32, -40, 70 },
    [MZ2_BOSS2_MACHINEGUN_L5] = { 32, -40, 70 },

    [MZ2_BOSS2_ROCKET_1] = { 22, 16, 10 },
    [MZ2_BOSS2_ROCKET_2] = { 22, 8, 10 },
    [MZ2_BOSS2_ROCKET_3] = { 22, -8, 10 },
    [MZ2_BOSS2_ROCKET_4] = { 22, -16, 10 },

    [MZ2_FLOAT_BLASTER_1] = { 32.5f, -0.8f, 10 },

    [MZ2_SOLDIER_BLASTER_3] = { 20.8f * 1.2f, 10.1f * 1.2f, -2.7f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_3] = { 20.8f * 1.2f, 10.1f * 1.2f, -2.7f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_3] = { 20.8f * 1.2f, 10.1f * 1.2f, -2.7f * 1.2f },
    [MZ2_SOLDIER_BLASTER_4] = { 7.6f * 1.2f, 9.3f * 1.2f, 0.8f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_4] = { 7.6f * 1.2f, 9.3f * 1.2f, 0.8f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_4] = { 7.6f * 1.2f, 9.3f * 1.2f, 0.8f * 1.2f },
    [MZ2_SOLDIER_BLASTER_5] = { 30.5f * 1.2f, 9.9f * 1.2f, -18.7f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_5] = { 30.5f * 1.2f, 9.9f * 1.2f, -18.7f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_5] = { 30.5f * 1.2f, 9.9f * 1.2f, -18.7f * 1.2f },
    [MZ2_SOLDIER_BLASTER_6] = { 27.6f * 1.2f, 3.4f * 1.2f, -10.4f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_6] = { 27.6f * 1.2f, 3.4f * 1.2f, -10.4f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_6] = { 27.6f * 1.2f, 3.4f * 1.2f, -10.4f * 1.2f },
    [MZ2_SOLDIER_BLASTER_7] = { 28.9f * 1.2f, 4.6f * 1.2f, -8.1f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_7] = { 28.9f * 1.2f, 4.6f * 1.2f, -8.1f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_7] = { 28.9f * 1.2f, 4.6f * 1.2f, -8.1f * 1.2f },
    [MZ2_SOLDIER_BLASTER_8] = { 31.5f * 1.2f, 9.6f * 1.2f, 10.1f * 1.2f },
    [MZ2_SOLDIER_SHOTGUN_8] = { 34.5f * 1.2f, 9.6f * 1.2f, 6.1f * 1.2f },
    [MZ2_SOLDIER_MACHINEGUN_8] = { 34.5f * 1.2f, 9.6f * 1.2f, 6.1f * 1.2f },

    [MZ2_MAKRON_BFG] = { 17, -19.5f, 62.9f },
    [MZ2_MAKRON_BLASTER_1] = { -3.6f, -24.1f, 59.5f },
    [MZ2_MAKRON_BLASTER_2] = { -1.6f, -19.3f, 59.5f },
    [MZ2_MAKRON_BLASTER_3] = { -0.1f, -14.4f, 59.5f },
    [MZ2_MAKRON_BLASTER_4] = { 2.0f, -7.6f, 59.5f },
    [MZ2_MAKRON_BLASTER_5] = { 3.4f, 1.3f, 59.5f },
    [MZ2_MAKRON_BLASTER_6] = { 3.7f, 11.1f, 59.5f },
    [MZ2_MAKRON_BLASTER_7] = { -0.3f, 22.3f, 59.5f },
    [MZ2_MAKRON_BLASTER_8] = { -6, 33, 59.5f },
    [MZ2_MAKRON_BLASTER_9] = { -9.3f, 36.4f, 59.5f },
    [MZ2_MAKRON_BLASTER_10] = { -7, 35, 59.5f },
    [MZ2_MAKRON_BLASTER_11] = { -2.1f, 29, 59.5f },
    [MZ2_MAKRON_BLASTER_12] = { 3.9f, 17.3f, 59.5f },
    [MZ2_MAKRON_BLASTER_13] = { 6.1f, 5.8f, 59.5f },
    [MZ2_MAKRON_BLASTER_14] = { 5.9f, -4.4f, 59.5f },
    [MZ2_MAKRON_BLASTER_15] = { 4.2f, -14.1f, 59.5f },
    [MZ2_MAKRON_BLASTER_16] = { 2.4f, -18.8f, 59.5f },
    [MZ2_MAKRON_BLASTER_17] = { -1.8f, -25.5f, 59.5f },
    [MZ2_MAKRON_RAILGUN_1] = { 18.1f, 7.8f, 74.4f },

    [MZ2_JORG_MACHINEGUN_L1] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_L2] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_L3] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_L4] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_L5] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_L6] = { 78.5f, -47.1f, 96 },
    [MZ2_JORG_MACHINEGUN_R1] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_MACHINEGUN_R2] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_MACHINEGUN_R3] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_MACHINEGUN_R4] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_MACHINEGUN_R5] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_MACHINEGUN_R6] = { 78.5f, 46.7f, 96 },
    [MZ2_JORG_BFG_1] = { 6.3f, -9, 111.2f },

    [MZ2_BOSS2_MACHINEGUN_R1] = { 32, 40, 70 },
    [MZ2_BOSS2_MACHINEGUN_R2] = { 32, 40, 70 },
    [MZ2_BOSS2_MACHINEGUN_R3] = { 32, 40, 70 },
    [MZ2_BOSS2_MACHINEGUN_R4] = { 32, 40, 70 },
    [MZ2_BOSS2_MACHINEGUN_R5] = { 32, 40, 70 },

    [MZ2_CARRIER_MACHINEGUN_L1] = { 56, -32, 32 },
    [MZ2_CARRIER_MACHINEGUN_R1] = { 56, 32, 32 },
    [MZ2_CARRIER_GRENADE] = { 42, 24, 50 },
    [MZ2_TURRET_MACHINEGUN] = { 20, 0, 0 },
    [MZ2_TURRET_ROCKET] = { 20, 0, 0 },
    [MZ2_TURRET_BLASTER] = { 20, 0, 0 },
    [MZ2_STALKER_BLASTER] = { 24, 0, 6 },
    [MZ2_DAEDALUS_BLASTER] = { 1.7f, 7.0f, 11.3f },
    [MZ2_MEDIC_BLASTER_2] = { 44.0f, 3.0f, 14.4f },
    [MZ2_CARRIER_RAILGUN] = { 32, 0, 6 },
    [MZ2_WIDOW_DISRUPTOR] = { 64.72f, 14.50f, 88.81f },
    [MZ2_WIDOW_BLASTER] = { 56, 32, 32 },
    [MZ2_WIDOW_RAIL] = { 62, -20, 84 },
    [MZ2_WIDOW_PLASMABEAM] = { 32, 0, 6 },
    [MZ2_CARRIER_MACHINEGUN_L2] = { 61, -32, 12 },
    [MZ2_CARRIER_MACHINEGUN_R2] = { 61, 32, 12 },
    [MZ2_WIDOW_RAIL_LEFT] = { 17, -62, 91 },
    [MZ2_WIDOW_RAIL_RIGHT] = { 68, 12, 86 },
    [MZ2_WIDOW_BLASTER_SWEEP1] = { 47.5f, 56, 89 },
    [MZ2_WIDOW_BLASTER_SWEEP2] = { 54, 52, 91 },
    [MZ2_WIDOW_BLASTER_SWEEP3] = { 58, 40, 91 },
    [MZ2_WIDOW_BLASTER_SWEEP4] = { 68, 30, 88 },
    [MZ2_WIDOW_BLASTER_SWEEP5] = { 74, 20, 88 },
    [MZ2_WIDOW_BLASTER_SWEEP6] = { 73, 11, 87 },
    [MZ2_WIDOW_BLASTER_SWEEP7] = { 73, 3, 87 },
    [MZ2_WIDOW_BLASTER_SWEEP8] = { 70, -12, 87 },
    [MZ2_WIDOW_BLASTER_SWEEP9] = { 67, -20, 90 },
    [MZ2_WIDOW_BLASTER_100] = { -20, 76, 90 },
    [MZ2_WIDOW_BLASTER_90] = { -8, 74, 90 },
    [MZ2_WIDOW_BLASTER_80] = { 0, 72, 90 },
    [MZ2_WIDOW_BLASTER_70] = { 10, 71, 89 },
    [MZ2_WIDOW_BLASTER_60] = { 23, 70, 87 },
    [MZ2_WIDOW_BLASTER_50] = { 32, 64, 85 },
    [MZ2_WIDOW_BLASTER_40] = { 40, 58, 84 },
    [MZ2_WIDOW_BLASTER_30] = { 48, 50, 83 },
    [MZ2_WIDOW_BLASTER_20] = { 54, 42, 82 },
    [MZ2_WIDOW_BLASTER_10] = { 56, 34, 82 },
    [MZ2_WIDOW_BLASTER_0] = { 58, 26, 82 },
    [MZ2_WIDOW_BLASTER_10L] = { 60, 16, 82 },
    [MZ2_WIDOW_BLASTER_20L] = { 59, 6, 81 },
    [MZ2_WIDOW_BLASTER_30L] = { 58, -2, 80 },
    [MZ2_WIDOW_BLASTER_40L] = { 57, -10, 79 },
    [MZ2_WIDOW_BLASTER_50L] = { 54, -18, 78 },
    [MZ2_WIDOW_BLASTER_60L] = { 42, -32, 80 },
    [MZ2_WIDOW_BLASTER_70L] = { 36, -40, 78 },
    [MZ2_WIDOW_RUN_1] = { 68.4f, 10.88f, 82.08f },
    [MZ2_WIDOW_RUN_2] = { 68.51f, 8.64f, 85.14f },
    [MZ2_WIDOW_RUN_3] = { 68.66f, 6.38f, 88.78f },
    [MZ2_WIDOW_RUN_4] = { 68.73f, 5.1f, 84.47f },
    [MZ2_WIDOW_RUN_5] = { 68.82f, 4.79f, 80.52f },
    [MZ2_WIDOW_RUN_6] = { 68.77f, 6.11f, 85.37f },
    [MZ2_WIDOW_RUN_7] = { 68.67f, 7.99f, 90.24f },
    [MZ2_WIDOW_RUN_8] = { 68.55f, 9.54f, 87.36f },
    [MZ2_CARRIER_ROCKET_1] = { 0, 0, -5 },
    [MZ2_CARRIER_ROCKET_2] = { 0, 0, -5 },
    [MZ2_CARRIER_ROCKET_3] = { 0, 0, -5 },
    [MZ2_CARRIER_ROCKET_4] = { 0, 0, -5 },
    [MZ2_WIDOW2_BEAMER_1] = { 69.00f, -17.63f, 93.77f },
    [MZ2_WIDOW2_BEAMER_2] = { 69.00f, -17.08f, 89.82f },
    [MZ2_WIDOW2_BEAMER_3] = { 69.00f, -18.40f, 90.70f },
    [MZ2_WIDOW2_BEAMER_4] = { 69.00f, -18.34f, 94.32f },
    [MZ2_WIDOW2_BEAMER_5] = { 69.00f, -18.30f, 97.98f },
    [MZ2_WIDOW2_BEAM_SWEEP_1] = { 45.04f, -59.02f, 92.24f },
    [MZ2_WIDOW2_BEAM_SWEEP_2] = { 50.68f, -54.70f, 91.96f },
    [MZ2_WIDOW2_BEAM_SWEEP_3] = { 56.57f, -47.72f, 91.65f },
    [MZ2_WIDOW2_BEAM_SWEEP_4] = { 61.75f, -38.75f, 91.38f },
    [MZ2_WIDOW2_BEAM_SWEEP_5] = { 65.55f, -28.76f, 91.24f },
    [MZ2_WIDOW2_BEAM_SWEEP_6] = { 67.79f, -18.90f, 91.22f },
    [MZ2_WIDOW2_BEAM_SWEEP_7] = { 68.60f, -9.52f, 91.23f },
    [MZ2_WIDOW2_BEAM_SWEEP_8] = { 68.08f, 0.18f, 91.32f },
    [MZ2_WIDOW2_BEAM_SWEEP_9] = { 66.14f, 9.79f, 91.44f },
    [MZ2_WIDOW2_BEAM_SWEEP_10] = { 62.77f, 18.91f, 91.65f },
    [MZ2_WIDOW2_BEAM_SWEEP_11] = { 58.29f, 27.11f, 92.00f },

    [MZ2_SOLDIER_RIPPER_1] = { 10.6f * 1.2f, 7.7f * 1.2f, 7.8f * 1.2f },
    [MZ2_SOLDIER_RIPPER_2] = { 25.1f * 1.2f, 3.6f * 1.2f, 19.0f * 1.2f },
    [MZ2_SOLDIER_RIPPER_3] = { 20.8f * 1.2f, 10.1f * 1.2f, -2.7f * 1.2f },
    [MZ2_SOLDIER_RIPPER_4] = { 7.6f * 1.2f, 9.3f * 1.2f, 0.8f * 1.2f },
    [MZ2_SOLDIER_RIPPER_5] = { 30.5f * 1.2f, 9.9f * 1.2f, -18.7f * 1.2f },
    [MZ2_SOLDIER_RIPPER_6] = { 27.6f * 1.2f, 3.4f * 1.2f, -10.4f * 1.2f },
    [MZ2_SOLDIER_RIPPER_7] = { 28.9f * 1.2f, 4.6f * 1.2f, -8.1f * 1.2f },
    [MZ2_SOLDIER_RIPPER_8] = { 31.5f * 1.2f, 9.6f * 1.2f, 10.1f * 1.2f },

    [MZ2_SOLDIER_HYPERGUN_1] = { 10.6f * 1.2f, 7.7f * 1.2f, 7.8f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_2] = { 25.1f * 1.2f, 3.6f * 1.2f, 19.0f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_3] = { 20.8f * 1.2f, 10.1f * 1.2f, -2.7f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_4] = { 7.6f * 1.2f, 9.3f * 1.2f, 0.8f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_5] = { 30.5f * 1.2f, 9.9f * 1.2f, -18.7f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_6] = { 27.6f * 1.2f, 3.4f * 1.2f, -10.4f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_7] = { 28.9f * 1.2f, 4.6f * 1.2f, -8.1f * 1.2f },
    [MZ2_SOLDIER_HYPERGUN_8] = { 31.5f * 1.2f, 9.6f * 1.2f, 10.1f * 1.2f },

    [MZ2_GUARDIAN_BLASTER] = { 88.f, 50.f, 60.f },

    [MZ2_ARACHNID_RAIL1] = { 58.f, 20.f, 17.2f },
    [MZ2_ARACHNID_RAIL2] = { 64.f, -22.f, 24.f },
    [MZ2_ARACHNID_RAIL_UP1] = { 37.f, 13.f, 72.f },
    [MZ2_ARACHNID_RAIL_UP2] = { 58.f, -25.f, 72.f },

    [MZ2_INFANTRY_MACHINEGUN_14] = { 34.f, 11.f, 13.f },
    [MZ2_INFANTRY_MACHINEGUN_15] = { 28.f, 13.f, 10.5f },
    [MZ2_INFANTRY_MACHINEGUN_16] = { 29.f, 13.f, 8.5f },
    [MZ2_INFANTRY_MACHINEGUN_17] = { 30.f, 12.5f, 12.f },
    [MZ2_INFANTRY_MACHINEGUN_18] = { 29.f, 12.5f, 14.7f },
    [MZ2_INFANTRY_MACHINEGUN_19] = { 30.f, 6.5f, 12.f },
    [MZ2_INFANTRY_MACHINEGUN_20] = { 29.f, 1.5f, 8.5f },
    [MZ2_INFANTRY_MACHINEGUN_21] = { 29.f, 6.0f, 10.f },

    [MZ2_GUNCMDR_CHAINGUN_1] = { 25.0f, 11.f, 21.f },
    [MZ2_GUNCMDR_CHAINGUN_2] = { 26.5f, 5.f, 21.f },

    [MZ2_GUNCMDR_GRENADE_MORTAR_1] = { 27.f, 6.5f, 4.0f },
    [MZ2_GUNCMDR_GRENADE_MORTAR_2] = { 28.f, 4.f, 4.0f },
    [MZ2_GUNCMDR_GRENADE_MORTAR_3] = { 27.f, 1.7f, 4.0f },

    [MZ2_GUNCMDR_GRENADE_FRONT_1] = { 21.7f, -1.5f, 22.5f },
    [MZ2_GUNCMDR_GRENADE_FRONT_2] = { 22.f, 0.f, 20.5f },
    [MZ2_GUNCMDR_GRENADE_FRONT_3] = { 22.5f, 3.7f, 20.5f },

    [MZ2_GUNCMDR_GRENADE_CROUCH_1] = { 8.0f, 40.0f, 18.0f },
    [MZ2_GUNCMDR_GRENADE_CROUCH_2] = { 29.0f, 16.0f, 19.0f },
    [MZ2_GUNCMDR_GRENADE_CROUCH_3] = { 4.7f, -30.0f, 20.0f },

    [MZ2_SOLDIER_BLASTER_9] = { 36.33f, 12.24f, -17.39f },
    [MZ2_SOLDIER_SHOTGUN_9] = { 36.33f, 12.24f, -17.39f },
    [MZ2_SOLDIER_MACHINEGUN_9] = { 36.33f, 12.24f, -17.39f },
    [MZ2_SOLDIER_RIPPER_9] = { 36.33f, 12.24f, -17.39f },
    [MZ2_SOLDIER_HYPERGUN_9] = { 36.33f, 12.24f, -17.39f },

    [MZ2_GUNNER_GRENADE2_1] = { 36.f, -6.2f, 19.59f },
    [MZ2_GUNNER_GRENADE2_2] = { 36.f, -6.2f, 19.59f },
    [MZ2_GUNNER_GRENADE2_3] = { 36.f, -6.2f, 19.59f },
    [MZ2_GUNNER_GRENADE2_4] = { 36.f, -6.2f, 19.59f },

    [MZ2_INFANTRY_MACHINEGUN_22] = { 14.8f, 10.5f, 8.82f },

    [MZ2_SUPERTANK_GRENADE_1] = { 31.31f, -37.f, 54.32f },
    [MZ2_SUPERTANK_GRENADE_2] = { 31.31f, 37.f, 54.32f },

    [MZ2_HOVER_BLASTER_2] = { 1.7f, -7.0f, 11.3f },
    [MZ2_DAEDALUS_BLASTER_2] = { 1.7f, -7.0f, 11.3f },

    [MZ2_MEDIC_HYPERBLASTER1_1] = { 33.0f + 1.f, 12.5f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_2] = { 32.4f + 1.f, 11.2f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_3] = { 35.6f + 1.f, 7.4f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_4] = { 34.0f + 1.f, 4.1f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_5] = { 36.6f + 1.f, 1.0f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_6] = { 34.7f + 1.f, -1.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_7] = { 36.6f + 1.f, -0.5f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_8] = { 34.2f + 1.f, 2.8f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_9] = { 36.5f + 1.f, 3.8f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_10] = { 33.5f + 1.f, 6.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_11] = { 32.7f + 1.f, 9.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER1_12] = { 34.5f + 1.f, 11.0f, 15.0f },

    [MZ2_MEDIC_HYPERBLASTER2_1] = { 33.0f + 1.f, 12.5f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_2] = { 32.4f + 1.f, 11.2f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_3] = { 35.6f + 1.f, 7.4f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_4] = { 34.0f + 1.f, 4.1f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_5] = { 36.6f + 1.f, 1.0f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_6] = { 34.7f + 1.f, -1.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_7] = { 36.6f + 1.f, -0.5f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_8] = { 34.2f + 1.f, 2.8f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_9] = { 36.5f + 1.f, 3.8f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_10] = { 33.5f + 1.f, 6.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_11] = { 32.7f + 1.f, 9.9f, 15.0f },
    [MZ2_MEDIC_HYPERBLASTER2_12] = { 34.5f + 1.f, 11.0f, 15.0f },
};
