/*
Copyright (C) 2003-2006 Andrey Nazarov

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#pragma once

#include "../server.h"
#include <setjmp.h>

#define MVD_Malloc(size)    Z_TagMalloc(size, TAG_MVD)
#define MVD_Mallocz(size)   Z_TagMallocz(size, TAG_MVD)
#define MVD_CopyString(s)   Z_TagCopyString(s, TAG_MVD)

#define FOR_EACH_MVD(mvd) \
    LIST_FOR_EACH(mvd_t, mvd, &mvd_channel_list, entry)

#define FOR_EACH_MVDCL(cl, mvd) \
    LIST_FOR_EACH(mvd_client_t, cl, &(mvd)->clients, entry)

#define EDICT_MVDCL(ent)  ((mvd_client_t *)((ent)->client))

#define MVD_InfoSet(var, val) \
    Cvar_FullSet(var, val, CVAR_SERVERINFO | CVAR_GAME, FROM_CODE)

// game features MVD client supports
#define MVD_FEATURES    (GMF_CLIENTNUM | GMF_PROPERINUSE | GMF_WANT_ALL_DISCONNECTS)

// dummy flag to mark entity as seen
#define SVF_MVD_SEEN    BIT(31)

#define LAYOUT_MSEC     3000

typedef enum {
    LAYOUT_NONE,        // no layout at all
    LAYOUT_FOLLOW,      // display chase target name
    LAYOUT_SCORES,      // layout of the MVD dummy
    LAYOUT_OLDSCORES,   // saved at intermission time
    LAYOUT_MENU,        // MVD main menu
    LAYOUT_CLIENTS,     // MVD clients list
    LAYOUT_CHANNELS     // MVD channel list
} mvd_layout_t;

#define FLOOD_SAMPLES   16
#define FLOOD_MASK      (FLOOD_SAMPLES - 1)

typedef struct mvd_cs_s {
    struct mvd_cs_s *next;
    int index;
    char string[1];
} mvd_cs_t;

typedef struct {
    player_state_t ps;
    bool inuse;
    char name[16];
    mvd_cs_t *configstrings;
} mvd_player_t;

typedef struct {
    /* =================== */
    player_state_t ps;
    int ping;
    int clientNum;
    /* =================== */

    list_t          entry;
    struct mvd_s    *mvd;
    client_t        *cl;
    bool            admin;
    bool            notified;
    unsigned        begin_time;
    float           fov;
    int             uf;

    mvd_player_t    *target;
    mvd_player_t    *oldtarget;
    int             chase_mask;
    bool            chase_auto;
    bool            chase_wait;
    byte            chase_bitmap[MAX_CLIENTS / CHAR_BIT];

    mvd_layout_t    layout_type;
    unsigned        layout_time;
    int             layout_cursor;

    unsigned    floodSamples[FLOOD_SAMPLES];
    unsigned    floodHead;
    unsigned    floodTime;

    usercmd_t lastcmd;
    //short delta_angles[3];
    int jump_held;
} mvd_client_t;

#define MAX_MVD_NAME    16

typedef enum {
    MVD_DEAD,       // no gamestate received yet, unusable for observers
    MVD_WAITING,    // buffering more frames, stalled
    MVD_READING,    // reading frames

    MVD_NUM_STATES
} mvd_state_t;

typedef struct {
    int framenum;
    unsigned msglen;
    int64_t filepos;
    byte data[1];
} mvd_snap_t;

struct gtv_s;

// FIXME: entire struct is > 500 kB in size!
// need to eliminate those large static arrays below...
typedef struct mvd_s {
    list_t      entry;

    mvd_state_t     state;
    int             id;
    char            name[MAX_MVD_NAME];
    struct gtv_s    *gtv;
    bool            (*read_frame)(struct mvd_s *);
    bool            (*forward_cmd)(mvd_client_t *);

    // demo related variables
    qhandle_t   demorecording;
    char        *demoname;
    bool        demoseeking;
    int         last_snapshot;
    mvd_snap_t  **snapshots;
    int         numsnapshots;

    // delay buffer
    fifo_t      delay;
    unsigned    msglen;
    unsigned    num_packets, min_packets;
    unsigned    underflows, overflows;
    int         framenum;

    // game state
    char            gamedir[MAX_QPATH];
    char            mapname[MAX_QPATH];
    int             version;
    int             servercount;
    int             maxclients;
    game_export_t   ge;
    cm_t            cm;
    vec3_t          spawnOrigin;
    vec3_t          spawnAngles;
    int             pm_type;
    size_t          dcs[BC_COUNT(MAX_CONFIGSTRINGS)];
    configstring_t  baseconfigstrings[MAX_CONFIGSTRINGS];
    configstring_t  configstrings[MAX_CONFIGSTRINGS];
    const cs_remap_t *csr;
    msgEsFlags_t    esFlags;
    msgPsFlags_t    psFlags;
    edict_t         edicts[MAX_EDICTS];
    mvd_player_t    *players; // [maxclients]
    mvd_player_t    *dummy; // &players[clientNum]
    int             numplayers; // number of active players in frame
    int             clientNum;
    mvd_flags_t     flags;
    char        layout[MAX_NET_STRING];
    char        oldscores[MAX_NET_STRING]; // layout is copied here
    bool        intermission;
    bool        dirty;

    // UDP client list
    list_t      clients;
} mvd_t;


//
// mvd_client.c
//

extern list_t       mvd_channel_list;
extern mvd_t        mvd_waitingRoom;
extern bool         mvd_dirty;

extern bool         mvd_active;
extern unsigned     mvd_last_activity;

extern jmp_buf  mvd_jmpbuf;

#if USE_DEBUG
extern cvar_t    *mvd_shownet;
#endif

q_noreturn q_printf(2, 3)
void MVD_Destroyf(mvd_t *mvd, const char *fmt, ...);
void MVD_Shutdown(void);

mvd_t *MVD_SetChannel(int arg);

void MVD_File_g(genctx_t *ctx);

void MVD_Spawn(void);

void MVD_StopRecord(mvd_t *mvd);

void MVD_StreamedStop_f(void);
void MVD_StreamedRecord_f(void);

void MVD_Register(void);
int MVD_Frame(void);

//
// mvd_parse.c
//

bool MVD_ParseMessage(mvd_t *mvd);
void MVD_ParseEntityString(mvd_t *mvd, const char *data);
void MVD_ClearState(mvd_t *mvd, bool full);

//
// mvd_game.c
//

extern mvd_client_t     *mvd_clients;   // [maxclients]

void MVD_SwitchChannel(mvd_client_t *client, mvd_t *mvd);
void MVD_RemoveClient(client_t *client);
void MVD_BroadcastPrintf(mvd_t *mvd, int level,
                         int mask, const char *fmt, ...) q_printf(4, 5);
void MVD_PrepWorldFrame(void);
void MVD_GameClientNameChanged(edict_t *ent, const char *name);
void MVD_GameClientDrop(edict_t *ent, const char *prefix, const char *reason);
void MVD_UpdateClients(mvd_t *mvd);
void MVD_FreePlayer(mvd_player_t *player);
void MVD_UpdateConfigstring(mvd_t *mvd, int index);
void MVD_WriteStringList(mvd_client_t *client, mvd_cs_t *cs);
void MVD_SetPlayerNames(mvd_t *mvd);
void MVD_LinkEdict(mvd_t *mvd, edict_t *ent);
